-- On cre la base avec ses fichiers et groupes de fichiers
CREATE DATABASE DB_VL
ON PRIMARY
      (NAME = 'F_META',
       FILENAME = 'C:\DataBases\DATA\DB_VL.mdf'),
   FILEGROUP FG_DATA DEFAULT
      (NAME = 'F_DATA1',
       FILENAME = 'C:\DataBases\DATA\DB_VL_data1.ndf'),
      (NAME = 'F_DATA2',
       FILENAME = 'C:\DataBases\DATA\DB_VL_data2.ndf'),
   FILEGROUP FG_INDX
      (NAME = 'F_INDX1',
       FILENAME = 'C:\DataBases\DATA\DB_VL_indx1.ndf'),
   FILEGROUP FG_RO
      (NAME = 'F_RO',
       FILENAME = 'C:\DataBases\DATA\DB_VL_RO.ndf')
LOG ON
      (NAME = 'F_TRAN',
       FILENAME = 'C:\DataBases\TRAN\DB_VL_tran.ldf');
GO

-- La base est place en mode de rcupration FULL
ALTER DATABASE DB_VL SET RECOVERY FULL;
GO

-- On se place dans le contexte de la base
USE DB_VL;
GO

-- On cre une table des clients dans le groupe de fichiers PRIMARY
CREATE TABLE T_CLIENT
(CLI_ID    INT PRIMARY KEY, 
 CLI_NOM   VARCHAR(32))
ON [PRIMARY];
GO
-- On cre une table des commandes dans le groupe de fichiers FG_DATA
CREATE TABLE T_COMMANDE
(CMD_ID     INT PRIMARY KEY,
 CLI_ID     INT FOREIGN KEY REFERENCES T_CLIENT (CLI_ID),
 CMD_DATE   DATE)
ON FG_DATA;
GO

-- On cre une table des code postaux dans le groupe de fichiers FG_RO
CREATE TABLE T_CODE_POSTAUX
(CPX_CODE    CHAR(5), 
 CPX_VILLE   VARCHAR(32))
ON FG_RO;
GO

-- On insre un client et sa commande
INSERT INTO T_CLIENT VALUES (1, 'DUPONT');
INSERT INTO T_COMMANDE VALUES (101, 1, '2013-01-01');
GO

-- On sauvegarde le fichier F_META prsent dans le groupe de fichiers PRIMARY,
-- qui ne contient que la table des clients
BACKUP DATABASE DB_VL FILE = 'F_META'
TO DISK = 'C:\DataBases\SAVE\DB_VL_F_META.BAK';
GO

-- On insre un nouveau client et sa commande
INSERT INTO T_CLIENT VALUES (2, 'MARTIN');
INSERT INTO T_COMMANDE VALUES (102, 2, '2013-01-02');
GO

-- On sauvegarde le groupe de fichiers FG_META,
-- qui ne contient que la table des commandes
BACKUP DATABASE DB_VL FILEGROUP = 'FG_DATA'
TO DISK = 'C:\DataBases\SAVE\DB_VL_FG_DATA.BAK';
GO

--  ce stade, la sauvegarde DB_VL_FG_DATA.BAK contient une commande sans client
-- On insre les codes postaux
INSERT INTO T_CODE_POSTAUX VALUES ('75001', 'PARIS');
GO

USE master;
-- On passe le groupe de fichiers FG_RO en lecture seule
ALTER DATABASE DB_VL MODIFY FILEGROUP FG_RO READ_ONLY;
GO

-- On sauvegarde le groupe de fichiers FG_RO en lecture seule,
-- qui ne contient que la table des codes postaux
BACKUP DATABASE DB_VL FILEGROUP = 'FG_RO'
TO DISK = 'C:\DataBases\SAVE\DB_VL_FG_RO.BAK';
GO

-- On sauvegarde tous les groupes de fichiers en lecture/criture
BACKUP DATABASE DB_VL READ_WRITE_FILEGROUPS
TO DISK = 'C:\DataBases\SAVE\DB_VL_READ_WRITE_FG.BAK';
GO